#ifndef SIMPLESHADER_H
#define SIMPLESHADER_H

#include <glad/glad.h>

#include <filesystem>
#include <optional>
#include <boost/noncopyable.hpp>

namespace simpleshader {

class ShaderObject : boost::noncopyable {
  public:
    ShaderObject(GLenum type, std::string const &src);
    ~ShaderObject();
    ShaderObject(ShaderObject &&other) noexcept;
    ShaderObject &operator=(ShaderObject &&other) noexcept;

    bool ok() const;
    GLuint name() const;

  private:
      GLenum type_;
      GLuint name_;
};

class ShaderProgram : boost::noncopyable {
  public:
    ShaderProgram(ShaderObject const &vert, ShaderObject const &frag);
    ~ShaderProgram();
    ShaderProgram(ShaderProgram &&other) noexcept;
    ShaderProgram &operator=(ShaderProgram &&other) noexcept;

    bool ok() const;
    GLuint name() const;
    void clear();

  private:
    GLuint name_;
};

std::optional<std::string> read_to_string(std::filesystem::path const &path);

void print_compilation_errors(ShaderObject const &shader, std::filesystem::path const &path);

void print_link_errors(ShaderProgram const &program);

}  // namespace simpleshader

#endif
